/*
 * Decompiled with CFR 0.152.
 */
package dev.toma.gunsrpg.util.properties;

import dev.toma.gunsrpg.util.properties.IPropertySerializer;
import net.minecraft.network.PacketBuffer;

public final class PrimitiveSerializers {
    public static final IPropertySerializer<Boolean> BOOLEAN = PrimitiveSerializers.of(PacketBuffer::writeBoolean, PacketBuffer::readBoolean);
    public static final IPropertySerializer<Integer> INT = PrimitiveSerializers.of(PacketBuffer::writeInt, PacketBuffer::readInt);
    public static final IPropertySerializer<Float> FLOAT = PrimitiveSerializers.of(PacketBuffer::writeFloat, PacketBuffer::readFloat);
    public static final IPropertySerializer<String> STRING = PrimitiveSerializers.of(PacketBuffer::func_180714_a, PacketBuffer::func_218666_n);

    public static <T> IPropertySerializer<T> of(IEncoder<T> encoder, IDecoder<T> decoder) {
        return new PrimitiveSerializer<T>(encoder, decoder);
    }

    private static class PrimitiveSerializer<V>
    implements IPropertySerializer<V> {
        private final IEncoder<V> encoder;
        private final IDecoder<V> decoder;

        PrimitiveSerializer(IEncoder<V> encoder, IDecoder<V> decoder) {
            this.encoder = encoder;
            this.decoder = decoder;
        }

        @Override
        public void encode(PacketBuffer buffer, V value) {
            this.encoder.encode(buffer, value);
        }

        @Override
        public V decode(PacketBuffer buffer) {
            return this.decoder.decode(buffer);
        }
    }

    private static interface IDecoder<T> {
        public T decode(PacketBuffer var1);
    }

    private static interface IEncoder<T> {
        public void encode(PacketBuffer var1, T var2);
    }
}

